(*********************************************
This demo shows you how to create TSprite-derived objects
(in this case, TSquareSprites, which are derived from
TPolygonSprites).  It also illustrates the DirtyRectangles
and Stretch properties.  A frame counter is displayed so
you can see how changing these properties affects the
frame rate.
*********************************************)
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  TurboSprite, ThreadTimer, ExtCtrls, ColorPalette, Sprites, StdCtrls;

type
  TForm1 = class(TForm)
    ThreadTimer1: TThreadTimer;
    SpriteSurface1: TSpriteSurface;
    ColorPalette1: TColorPalette;
    SpriteEngine1: TSpriteEngine;
    btnCreate: TButton;
    timerFrames: TTimer;
    pnlFrames: TPanel;
    cbDirty: TCheckBox;
    cbStretch: TCheckBox;
    btnRemove: TButton;
    pnlSprites: TPanel;
    procedure ThreadTimer1Timer(Sender: TObject);
    procedure btnCreateClick(Sender: TObject);
    procedure timerFramesTimer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure cbDirtyClick(Sender: TObject);
    procedure cbStretchClick(Sender: TObject);
    procedure btnRemoveClick(Sender: TObject);
  private
    nFrames: integer;
    nSprites: integer;
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.ThreadTimer1Timer(Sender: TObject);
begin
  SpriteSurface1.DIBRefresh;
  Inc( nFrames );
end;

procedure TForm1.btnCreateClick(Sender: TObject);
var
  sqr: TSquareSprite;
begin
  sqr := TSquareSprite.CreatePolygonSprite( MoveTowardDestination, Random(255) );
  with sqr do
  begin
    Speed := Random * 10;
    Position := SpriteSurface1.randomPoint;
    Destination := SpriteSurface1.randomPoint;
    SpinType := TSpinType( Random(3) );
    SpinSpeed := Random( 20 );
    Filled := Random > 0.5;
  end;
  SpriteEngine1.addSprite( sqr );
  Inc( nSprites );
  pnlSprites.Caption := IntToStr( nSprites ) + ' Sprites'; 
end;

procedure TForm1.timerFramesTimer(Sender: TObject);
begin
  pnlFrames.Caption := IntToStr(nFrames) + ' Frames/Sec';
  nFrames := 0;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Randomize;
end;

procedure TForm1.cbDirtyClick(Sender: TObject);
begin
  SpriteSurface1.DirtyRectangles := cbDirty.Checked;
end;

procedure TForm1.cbStretchClick(Sender: TObject);
begin
  SpriteSurface1.Stretch := cbStretch.Checked;
end;

procedure TForm1.btnRemoveClick(Sender: TObject);
begin
  SpriteEngine1.removeAllSprites;
  pnlSprites.Caption := '0 Sprites';
  nSprites := 0;
end;

end.
